import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;

import quadbase.reportdesigner.ReportAPI.QbReport;
import quadbase.reportdesigner.ReportViewer.Viewer;
import quadbase.reportdesigner.util.ColInfo;

public class FixedFieldCrosstab extends Applet {

	static final long serialVersionUID = 1;

	public static void main(String[] args) throws Exception {

		try {

			FixedFieldCrosstab doReport = new FixedFieldCrosstab();
			Frame frame = new Frame();
			frame.setLayout(new BorderLayout());
			frame.add("Center", doReport.doCrossTabReport(frame));
			frame.setSize(900, 800);
			frame.addWindowListener(new WindowAdapter() {
				@Override
				public void windowClosing(WindowEvent e) {
					System.exit(0);
				}
			});
			frame.setVisible(true);

		} catch (Exception ex) {

			ex.printStackTrace();

		}
	}

	@Override
	public void init() {

		setLayout(new BorderLayout());
		add("Center", doCrossTabReport(this));

	}

	Component doCrossTabReport(Object parent) {

		QbReport.setEspressManagerUsed(false);

		ColInfo colInfo[] = new ColInfo[4];

		colInfo[0] = new ColInfo(0);
		colInfo[1] = new ColInfo(1);
		colInfo[2] = new ColInfo(2);
		colInfo[3] = new ColInfo(3);

		colInfo[0].setRowBreak(true);
		colInfo[1].setColumnBreak(true);
		colInfo[2].setColumnBreak(true);
		colInfo[3].setColumnBreakValue(true);
		colInfo[3].setAggregation(ColInfo.SUM);

		Properties props = new Properties();
		props.put("crossTabFreeForm", "false"); // Using fixed-field form
		props.put("crossTabSummaryPositionL", "false"); // Draw summary column to the right of the details matrix 
		props.put("crossTabFormulaOnHeader", "true"); // Draw formula column in the header section
		props.put("crossTabColBkValAlignH", "false"); // Align Column Break Value vertically         

		QbReport report = new QbReport
				(parent, // Parent
						QbReport.CROSSTAB, // Report Type
						QbReport.DATAFILE, // Data Type
						"sample.dat", // Filename
						colInfo, // Column Mapping
						"field.rpt", // Template
						props); // Properties	    	

		try {
			report.refresh();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return (new Viewer().getComponent(report));

	}
}
