import java.applet.Applet;
import java.awt.Frame;
import java.io.FileOutputStream;
import java.util.Properties;

import javax.swing.JMenu;

import quadbase.chart.designer.IByPassSaveAsForChart;
import quadbase.chart.designer.IChartIO;
import quadbase.chart.designer.QbChartDesigner;
import quadbase.reportdesigner.designer.IByPassSaveAsForReport;
import quadbase.reportdesigner.designer.IChartHandle;
import quadbase.reportdesigner.designer.IReportIO;
import quadbase.reportdesigner.designer.QbReportDesigner;

//Run this example from ERES install directory
//Report manager must be running
public class RDWithCustomMessageERES extends Applet {
	// set following constants, your ERES server must be runnning!
	static final String ServletRunner = "http://localhost:8080";
	static final String ServletContext = "ERES/servlet";

	public static void main(String[] args) {

		try {
			startDesigner();
		} catch (Exception ex) {
			ex.printStackTrace();
		}

	}

	@Override
	public void init() {
		try {
			startDesigner();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	static void startDesigner() {
		QbReportDesigner.useServlet(true);
		QbReportDesigner.setServletRunner(ServletRunner);
		QbReportDesigner.setServletContext(ServletContext);
		QbReportDesigner.setUseSysResourceImages(true);

		QbReportDesigner designer = new QbReportDesigner((Frame) null);
		//		modify warning message before adding drill-down layer
		designer.modifyWarningMessage(QbReportDesigner.SAVE_RPT_BEFORE_DRILLDOWN,
				"The report designer will save the current report for you, continue?");

		//		modify warning message before inserting subreport
		designer.modifyWarningMessage(QbReportDesigner.SAVE_RPT_BEFORE_SUBREPORT,
				"The report designer will save the current report for you, continue?");

		//		by pass save as dialog when submitting save location
		designer.setReportIO(new ReportIO(designer));

		//		by pass save as dialog when user try to navigate to next level
		designer.setByPassSaveAsIO(new ByPassSaveAsForReport());

		//		modify chart designer from report
		designer.setChartDesignerHandle(new ChartDesignerHandle());

		//		REMOVE "SAVE AS" option for Report Designer
		JMenu fileMenu = designer.getReportMenuBar().getMenu(0);
		fileMenu.remove(6);
		designer.setVisible(true);

	}

	public static class ReportIO implements IReportIO {

		String fileName = null;
		QbReportDesigner designer = null;

		public ReportIO(QbReportDesigner designer) {
			this.designer = designer;
		}

		public void saveFile(byte[] data, String fileName) {

			System.out.println("SAVE REPORT FILE - " + fileName);
			try {

				FileOutputStream fout = new FileOutputStream(fileName);
				fout.write(data, 0, data.length);

			} catch (Exception ex) {

				ex.printStackTrace();

			}
			this.fileName = fileName;

		}
	}

	public static class ByPassSaveAsForReport implements IByPassSaveAsForReport {

		public ByPassSaveAsForReport() {
		};

		public String getFileName(String originalFileName) {

			System.out.println("BY PASS REPORT SAVE AS OPTION...");
			if (originalFileName == null) {
				return "TEMP_REPORT_FILE.rpt";
			} else {
				return originalFileName;
			}

		}

		public Properties getSaveAsProperties(String originalFileName) {

			return new Properties();

		}

	}

	public static class ChartDesignerHandle implements IChartHandle {

		public ChartDesignerHandle() {
		};

		public void processDesigner(QbChartDesigner designer) {

			System.out.println("PROCESS CHART....");
			//			REMOVE "SAVE AS" option for Chart Designer
			JMenu fileMenu = designer.getChartMenuBar().getMenu(0);
			fileMenu.remove(6);
			designer.setChartIO(new ChartIO());
			designer.setByPassSaveAsIO(new ByPassSaveAsForChart());

		}

	}

	public static class ChartIO implements IChartIO {

		public ChartIO() {
		};

		public String saveChartFile(byte[] data, String fileName) {

			System.out.println("SAVE CHART FILE - " + fileName);
			try {

				FileOutputStream fout = new FileOutputStream(fileName);
				fout.write(data, 0, data.length);
				fout.close();

			} catch (Exception ex) {

				ex.printStackTrace();

			}

			return fileName;

		}

	}

	public static class ByPassSaveAsForChart implements IByPassSaveAsForChart {

		public ByPassSaveAsForChart() {
		};

		public String getFileName(String originalFileName) {

			System.out.println("BY PASS CHART SAVE AS OPTION...");
			if (originalFileName == null) {
				return "TEMP_CHART_FILE.cht";
			} else {
				return originalFileName;
			}

		}

		public Properties getSaveAsProperties(String originalFileName) {

			return new Properties();

		}

	}

}