import java.util.Calendar;

import quadbase.reportdesigner.util.IExportConstants;
import quadbase.scheduler.ScheduleModifier;
import quadbase.scheduler.ScheduleObject;

//Report manager must be running
public class SchedulingExportReportTime {

	public static void main(String[] args) {
		SchedulingExportReportTime doScheduleExport = new SchedulingExportReportTime();
		try {
			doScheduleExport.createScheduleObject();
		} catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}

	void createScheduleObject() throws Exception {
		ScheduleModifier.setServerAddress("127.0.0.1");
		ScheduleModifier.setServerPortNumber(22071);

		ScheduleObject sObj = new ScheduleObject("Report_Time", ScheduleObject.REPORTOBJ);
		sObj.setFileLocation("Account.rpt");
		String exportLoc = sObj.pickDefaultExportLocation();
		sObj.setReportType(IExportConstants.PDF);
		sObj.setTaskOption(ScheduleObject.FIXED_DAYS);
		/*** export every 2 hrs. monday through friday ****/
		sObj.setSpecifyDays(new int[] { 1, 2, 3, 4, 5 });
		sObj.setStartTime(9 * 60); // 9:00AM in minutes
		sObj.setEndTime(22 * 60); // 10:00PM in minutes
		sObj.setTimeInterval(2 * 60); // export every 2 hours
		/*** export at specific times on specific dates ***/
		// sObj.setSpecifyDates(new int[]{26,27,28,29}); // export on specific dates
		// sObj.setSpecifyTime(new int[]{16 * 60, 17 * 60, 18 * 60}); // 4PM, 5PM and 6PM in minute
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.MINUTE, 5);
		sObj.setStartDate(calendar.getTimeInMillis());
		sObj.setEndDate(-1); // run indefinitely
		sObj.setSendEmail(false);

		ScheduleModifier.addScheduleTask(sObj);
	}
}
